/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed*0.3
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

#ifdef GL_ES
precision mediump float;
#endif

//dashxdr
// showing the points while performing the mandelbrot function
// http://glsl.heroku.com/e#7185

//uniform float iGlobalTime;
//uniform vec3 iResolution;
//uniform vec2 iMouse;
//uniform sampler2D bb;

void main( void )
{

	float sum = 0.0;
	float size = .0020;
	vec2 tpos = gl_FragCoord.xy / iResolution.xy - .5;
	float px,py;
	float scale = 2.0;
	float basex = -0.5;
	float basey = 0.0;
	float x = basex + (iMouse.x-.5)*scale;
	float y = basey + (iMouse.y-.5)*scale;
	float t;
	if(true) // change to false to control with mouse
	{
		t = iGlobalTime;
		float t1 = t;
		float scale1 = .3;
		float t2 = t *.61223;
		float scale2 = .5;
		x = basex + scale1*cos(t1) + scale2*cos(t2);
		y = basey + scale1*sin(t1) + scale2*sin(t2);
	}

	vec2 position = 2.0 * tpos + vec2(basex, basey);

#define NUM 30
	float u, v;
	u = v = .317;

	for(int j=0;j<4;++j)
	{
		px = py = 0.0;
		float x0, y0;
		x0 = x + u;
		y0 = y + v;
		for (int i=0; i < NUM; ++i) {
			t = (px*px-py*py)+x0;
			py = (2.0*px*py) + y0;
			px = t;
			float dist = length(vec2(px, py) - position);
			if(dist > .0001)
				sum += size/dist;
			else break;
		}
		t = u;
		u = -v;
		v = t;
	}

	float val = sum;

	vec3 color;
	color = vec3(val, val*0.66666, 0.0);
	tpos *= 1.2;
//#define INDENT .001
//	vec3 tcolor;
//	if(tpos.x>-.5 + INDENT && tpos.y>-.5 + INDENT &&
//		tpos.x < .5-INDENT && tpos.y < .5-INDENT)
//		tcolor = .9*texture2D(iChannel0, pos+.5).rgb;
//	else 
//tcolor = vec3(0.0);
//	gl_FragColor = vec4(max(color,tcolor), 1.0);
	gl_FragColor = vec4(color, 1.0);
}
